function discounts = convert_zero_rates_discounts2(term_structure, T)
% --------------------------------------------------------------------------------------------------
% Same as 'convert_zero_rates_discounts2' but for non-standard maturities.
% --------------------------------------------------------------------------------------------------
% term_structure    ... zero coupon rates with quarterly spacing of maturities
% T                 ... maturities of interest for each date
% --------------------------------------------------------------------------------------------------
% sample call: 
%   test = convert_swapcurves_termstructure2(swap_curves, swap_maturities, swap_dates, {'11/20/2006'; '11/21/2006'}, [1 5; 0.24 4.9974])
%   convert_zero_rates_discounts2(test, [1 5; 0.24 4.9974])
% --------------------------------------------------------------------------------------------------

% Only calculate discount curves, for which data is available
T = T(find(logical(term_structure.was_available)),:);
dates = term_structure.dates;
r_term = term_structure.zero_rates;

% Calculate discount factors for end and middle of periods
discounts = 1 ./ (1 + r_term).^T;
r_term2 = (r_term + [r_term(:,1) r_term(:,1:end-1)])/2;
T_inbetween = max(0, (T - 1/8));
discounts_inbetween = 1 ./ (1 + r_term2).^T_inbetween;

% Put discounts into structure
discounts = struct('discounts', {discounts}, 'discounts_inbetween', {discounts_inbetween}, ...
                   'horizon', T, 'horizon_inbetween', T_inbetween, 'dates', {dates});
